<?php
/**
* Twitter options.
*
* @package Minimal Lite
*/

$default = minimal_lite_get_default_customizer_values();
// Webmaster Panel.
$wp_customize->add_panel( 'minimal_lite_twitter',
	array(
		'title'      => esc_html__( 'Twitter Summary Card', 'minimal-lite' ),
		'priority'   => 200,
		'capability' => 'edit_theme_options',
	)
);

$wp_customize->add_section( 'tmt_twitter_summary_ed_sec', array(
        'title'    	=> __( 'Twitter Summary Enable Disable', 'minimal-lite' ),
        'panel'		=> 'minimal_lite_twitter',
        
) );

// Enable Disable Twitter Summary.
$wp_customize->add_setting('tmt_ed_twitter_summary',
    array(
        'default' => '',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'minimal_lite_sanitize_checkbox',
    )
);
$wp_customize->add_control('tmt_ed_twitter_summary',
    array(
        'label' => esc_html__('Enable Twitter Summary', 'minimal-lite'),
        'description' => esc_html__('Add meta on head for Twitter Summary.', 'minimal-lite'),
        'section' => 'tmt_twitter_summary_ed_sec',
        'type' => 'checkbox',
        'priority' => 1,
    )
);

$wp_customize->add_section( 'tmt_twitter_summary_home_sec', array(
        'title'    	=> __( 'Homepage Setting', 'minimal-lite' ),
        'panel'		=> 'minimal_lite_twitter',
        
) );


// Twitter Summary Title.
$wp_customize->add_setting( 'tmt_twitter_summary_title',
	array(
	'default'           => $default['tmt_twitter_summary_title'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'tmt_twitter_summary_title',
	array(
	'label'    => esc_html__( 'Title', 'minimal-lite' ),
	'section'  => 'tmt_twitter_summary_home_sec',
	'type'     => 'text',
	)
);

// Twitter Summary Description.
$wp_customize->add_setting( 'tmt_twitter_summary_desc',
	array(
	'default'           => $default['tmt_twitter_summary_desc'],
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'tmt_twitter_summary_desc',
	array(
	'label'    => esc_html__( 'Description', 'minimal-lite' ),
	'section'  => 'tmt_twitter_summary_home_sec',
	'type'     => 'text',
	)
);

// Twitter Summary Description.
$wp_customize->add_setting( 'tmt_twitter_summary_user',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'sanitize_text_field',
	)
);
$wp_customize->add_control( 'tmt_twitter_summary_user',
	array(
	'label'    => esc_html__( 'Username', 'minimal-lite' ),
	'section'  => 'tmt_twitter_summary_home_sec',
	'type'     => 'text',
	)
);

// Twitter Summary Description.
$wp_customize->add_setting( 'tmt_twitter_summary_site_type',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'minimal_lite_sanitize_select',
	)
);
$wp_customize->add_control( 'tmt_twitter_summary_site_type',
	array(
	'label'    => esc_html__( 'Twitter Card', 'minimal-lite' ),
	'section'  => 'tmt_twitter_summary_home_sec',
	'type'     => 'select',
	'choices'	=> array(
			'' => esc_html__('--select--','minimal-lite'),
			'summary' => esc_html__('summary','minimal-lite'),
			'summary_large_image' => esc_html__('Summary Large Image','minimal-lite'),
			'app' => esc_html__('APP','minimal-lite'),
			'player' => esc_html__('Player','minimal-lite'),
			'lead_generation' => esc_html__('Lead Generation','minimal-lite'),
			
		),
	)
);


// Header Advertise Image
$wp_customize->add_setting('tmt_twitter_summary_home_default_image',
    array(
        'default' => '',
        'sanitize_callback' => 'esc_url_raw'
    )
);
$wp_customize->add_control( new WP_Customize_Image_Control(
    $wp_customize,
    'tmt_twitter_summary_home_default_image',
    	array(
        	'label'      => esc_html__( 'Image for Home and Default Image.', 'minimal-lite' ),
           	'section'    => 'tmt_twitter_summary_home_sec',
           	'priority' => 10,
       	)
   	)
);


$wp_customize->add_section( 'tmt_twitter_summary_custom_meta_sec', array(
        'title'    	=> __( 'Custom Meta', 'minimal-lite' ),
        'panel'		=> 'minimal_lite_twitter',
        
) );

// Twitter Summary Suctom Meta.
$wp_customize->add_setting( 'tmt_twitter_summary_custom_meta',
	array(
	'default'           => '',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'minimal_lite_meta_sanitize',
	)
);
$wp_customize->add_control( 'tmt_twitter_summary_custom_meta',
	array(
	'label'    => esc_html__( 'Custom Meta', 'minimal-lite' ),
	'description'    => esc_html__( 'For example: <meta name="twitter:card" content="summary" />', 'minimal-lite' ),
	'section'  => 'tmt_twitter_summary_custom_meta_sec',
	'type'     => 'textarea',
	)
);